/*
 * Decompiled with CFR 0.152.
 */
package com.barcode;

import com.barcode.BufferedImageLuminanceSource;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Random;
import javax.imageio.ImageIO;

public class QRCode {
    private String CHARSET = "utf-8";
    private String FORMAT_NAME = "JPG";
    private int QRCODE_SIZE = 300;
    private int LOGO_WIDTH = 60;
    private int LOGO_HEIGHT = 60;

    private BufferedImage createImage(String content, String imgPath, boolean needCompress) throws Exception {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, this.CHARSET);
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, this.QRCODE_SIZE, this.QRCODE_SIZE, hints);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
                ++y;
            }
            ++x;
        }
        if (imgPath == null || "".equals(imgPath)) {
            return image;
        }
        this.insertImage(image, imgPath, needCompress);
        return image;
    }

    private void insertImage(BufferedImage source, String imgPath, boolean needCompress) throws Exception {
        File file = new File(imgPath);
        if (!file.exists()) {
            System.err.println(imgPath + "   \u8be5\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            return;
        }
        Image src = ImageIO.read(new File(imgPath));
        int width = ((Image)src).getWidth(null);
        int height = ((Image)src).getHeight(null);
        if (needCompress) {
            if (width > this.LOGO_WIDTH) {
                width = this.LOGO_WIDTH;
            }
            if (height > this.LOGO_HEIGHT) {
                height = this.LOGO_HEIGHT;
            }
            Image image = src.getScaledInstance(width, height, 4);
            BufferedImage tag = new BufferedImage(width, height, 1);
            Graphics g = tag.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            src = image;
        }
        Graphics2D graph = source.createGraphics();
        int x = (this.QRCODE_SIZE - width) / 2;
        int y = (this.QRCODE_SIZE - height) / 2;
        graph.drawImage(src, x, y, width, height, null);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width, width, 6.0f, 6.0f);
        graph.setStroke(new BasicStroke(3.0f));
        graph.draw(shape);
        graph.dispose();
    }

    public void encode(String content, String imgPath, String destPath, boolean needCompress) throws Exception {
        BufferedImage image = this.createImage(content, imgPath, needCompress);
        this.mkdirs(destPath);
        String file = String.valueOf(new Random().nextInt(99999999)) + ".jpg";
        ImageIO.write((RenderedImage)image, this.FORMAT_NAME, new File(String.valueOf(destPath) + "/" + file));
    }

    public void mkdirs(String destPath) {
        File file = new File(destPath);
        if (!file.exists() && !file.isDirectory()) {
            file.mkdirs();
        }
    }

    public void encode(String content, String imgPath, String destPath) throws Exception {
        this.encode(content, imgPath, destPath, false);
    }

    public void encode(String content, String destPath, boolean needCompress) throws Exception {
        this.encode(content, null, destPath, needCompress);
    }

    public void encode(String content, String destPath) throws Exception {
        this.encode(content, null, destPath, false);
    }

    public void encode(String content, String imgPath, OutputStream output, boolean needCompress) throws Exception {
        BufferedImage image = this.createImage(content, imgPath, needCompress);
        ImageIO.write((RenderedImage)image, this.FORMAT_NAME, output);
    }

    public void encode(String content, OutputStream output) throws Exception {
        this.encode(content, null, output, false);
    }

    public String decode(File file) throws Exception {
        BufferedImage image = ImageIO.read(file);
        if (image == null) {
            return null;
        }
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        Hashtable<DecodeHintType, String> hints = new Hashtable<DecodeHintType, String>();
        hints.put(DecodeHintType.CHARACTER_SET, this.CHARSET);
        Result result = new MultiFormatReader().decode(bitmap, hints);
        String resultStr = result.getText();
        return resultStr;
    }

    public String decode(String path) throws Exception {
        return this.decode(new File(path));
    }

    public String getCHARSET() {
        return this.CHARSET;
    }

    public void setCHARSET(String cHARSET) {
        this.CHARSET = cHARSET;
    }

    public String getFORMAT_NAME() {
        return this.FORMAT_NAME;
    }

    public void setFORMAT_NAME(String fORMAT_NAME) {
        this.FORMAT_NAME = fORMAT_NAME;
    }

    public int getQRCODE_SIZE() {
        return this.QRCODE_SIZE;
    }

    public void setQRCODE_SIZE(int qRCODE_SIZE) {
        this.QRCODE_SIZE = qRCODE_SIZE;
    }

    public int getLOGO_WIDTH() {
        return this.LOGO_WIDTH;
    }

    public void setLOGO_WIDTH(int lOGO_WIDTH) {
        this.LOGO_WIDTH = lOGO_WIDTH;
    }

    public int getLOGO_HEIGHT() {
        return this.LOGO_HEIGHT;
    }

    public void setLOGO_HEIGHT(int lOGO_HEIGHT) {
        this.LOGO_HEIGHT = lOGO_HEIGHT;
    }

    public static void main(String[] args) throws Exception {
        QRCode qrc = new QRCode();
        String text = "http://www.yihaomen.com";
        qrc.encode(text, "c:/barcode");
        System.out.println("OK...");
    }
}

