/*
 * Decompiled with CFR 0.152.
 */
package application;

import com.barcode.BufferedImageLuminanceSource;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;

public class QrcodeUtil {
    public static void main(String[] args) throws Exception {
        String msg = QrcodeUtil.decode("image/gzh.jpg");
        System.out.println(msg);
    }

    public static String decode(String file) throws Exception {
        InputStream input = QrcodeUtil.class.getResourceAsStream(file);
        BufferedImage image = ImageIO.read(input);
        if (image == null) {
            return null;
        }
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        Hashtable<DecodeHintType, String> hints = new Hashtable<DecodeHintType, String>();
        hints.put(DecodeHintType.CHARACTER_SET, "utf-8");
        Result result = new MultiFormatReader().decode(bitmap, hints);
        String resultStr = result.getText();
        return resultStr;
    }
}

