/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.ImageUtil;
import application.QrcodeUtil;
import com.barcode.BufferedImageLuminanceSource;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import com.rbj.tools.connection.ZkClientFactory;
import com.rbj.tools.connection.ZkMonito;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javax.imageio.ImageIO;

public class ZkTools
extends Application {
    private static boolean OK = false;

    public static void main(String[] args) throws Exception {
        String wx = ZkTools.decode("image/weixin.png");
        String zfb = ZkTools.decode("image/zhifubao.jpg");
        String gzh = ZkTools.decode("image/gzh.jpg");
        OK = "wxp://f2f0aDB4hzU869pNuEd3vcjy2rpxRkZUUmPF".equals(wx) && "HTTPS://QR.ALIPAY.COM/FKX00161OS42D6KPQVVTED".equals(zfb) && "http://weixin.qq.com/r/fCj44LDE7e2SrfSD931u".equals(gzh);
        ZkTools.launch((String[])args);
    }

    public void start(Stage primaryStage) throws Exception {
        if (OK) {
            this.zkMain(primaryStage);
        } else {
            this.errorMain(primaryStage);
        }
    }

    private void errorMain(Stage primaryStage) {
        try {
            HBox root = (HBox)FXMLLoader.load((URL)ZkTools.class.getResource("view/ErrorView.fxml"));
            ImageView err = (ImageView)root.getChildren().get(0);
            err.setImage(ImageUtil.TIMG);
            err.setFitWidth(400.0);
            err.setFitHeight(500.0);
            Scene scene = new Scene((Parent)root);
            primaryStage.setScene(scene);
            primaryStage.setResizable(false);
            primaryStage.setTitle("  zktools");
            primaryStage.getIcons().add((Object)ImageUtil.APP);
            primaryStage.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void zkMain(Stage primaryStage) {
        try {
            VBox root = (VBox)FXMLLoader.load((URL)ZkTools.class.getResource("view/MianView.fxml"));
            Scene scene = new Scene((Parent)root);
            primaryStage.setScene(scene);
            primaryStage.setHeight(650.0);
            primaryStage.setWidth(1030.0);
            primaryStage.setMinHeight(650.0);
            primaryStage.setMinWidth(1030.0);
            primaryStage.setTitle("  zktools");
            primaryStage.getIcons().add((Object)ImageUtil.APP);
            primaryStage.show();
            primaryStage.setOnCloseRequest(e -> {
                e.consume();
                this.close(primaryStage);
            });
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void close(Stage primaryStage) {
        System.out.println("\u5173\u95ed\u4e86\u4e3b\u7a97\u53e3");
        ZkMonito zkMonito = ZkMonito.singleton();
        if (zkMonito != null) {
            ZkMonito.stop();
            ZkClientFactory.close();
        }
        primaryStage.close();
    }

    private static String decode(String file) throws Exception {
        InputStream input = QrcodeUtil.class.getResourceAsStream(file);
        BufferedImage image = ImageIO.read(input);
        if (image == null) {
            return null;
        }
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        Hashtable<DecodeHintType, String> hints = new Hashtable<DecodeHintType, String>();
        hints.put(DecodeHintType.CHARACTER_SET, "utf-8");
        Result result = new MultiFormatReader().decode(bitmap, hints);
        String resultStr = result.getText();
        return resultStr;
    }
}

