/*
 * Decompiled with CFR 0.152.
 */
package application.controller;

import application.ImageUtil;
import application.tack.ConnectionTack;
import application.tack.ProgressFrom;
import application.window.Window;
import com.rbj.tools.action.MainAction;
import com.rbj.tools.connection.ZkClientFactory;
import com.rbj.tools.connection.ZkMonito;
import com.rbj.tools.item.ZkTreeCell;
import com.rbj.tools.item.ZkTreeItem;
import com.rbj.tools.listener.CacheListener;
import com.rbj.tools.listener.ZkMonitoListener;
import com.rbj.tools.util.URLUtil;
import com.rbj.tools.util.ZkPathUtil;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.data.Stat;

public class ZkMainController
extends MainAction
implements Initializable {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
    private static final String PATH = "/";
    @FXML
    private TextField zkUrl;
    @FXML
    private TextField rootNode;
    @FXML
    private Button conButt;
    @FXML
    private Button closeButt;
    @FXML
    private Button findButt;
    @FXML
    private TextField find;
    @FXML
    private TreeView<String> treeView;
    @FXML
    private TextArea nodeName;
    @FXML
    private TextArea nodeData;
    @FXML
    private CheckBox urlBox;
    @FXML
    private CheckBox meihua;
    @FXML
    private TextArea log;
    @FXML
    private Label ctime;
    @FXML
    private Label mtime;
    @FXML
    private Label version;
    @FXML
    private Label cZxid;
    @FXML
    private Label mZxid;
    @FXML
    private Label pZxid;
    @FXML
    private Label dataLength;
    @FXML
    private Label ephemeralOwner;
    @FXML
    private Label numChildren;
    @FXML
    private Label aversion;
    @FXML
    private Label cversion;
    @FXML
    private TextField ctimeText;
    @FXML
    private TextField mtimeText;
    @FXML
    private TextField versionText;
    @FXML
    private TextField cZxidText;
    @FXML
    private TextField mZxidText;
    @FXML
    private TextField pZxidText;
    @FXML
    private TextField dataLengthText;
    @FXML
    private TextField ephemeralOwnerText;
    @FXML
    private TextField numChildrenText;
    @FXML
    private TextField aversionText;
    @FXML
    private TextField cversionText;
    private ZkMonito zkmain;
    private String myName;
    private CuratorFramework client;
    private String treeRootNome;
    private boolean isSelection = false;

    public void initialize(URL arg0, ResourceBundle arg1) {
        ImageView ft = new ImageView(ImageUtil.SEARCH);
        ft.setFitWidth(28.0);
        ft.setFitHeight(28.0);
        this.findButt.setGraphic((Node)ft);
        this.find.setOnMouseClicked(e -> {
            if (this.conButt.isDisable()) {
                this.findButt.setDefaultButton(true);
            }
        });
        this.setTooltip();
        this.treeView.setCellFactory(p -> new ZkTreeCell());
        this.treeView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<String>>(){

            public void changed(ObservableValue<? extends TreeItem<String>> arg0, TreeItem<String> arg1, TreeItem<String> tt) {
                if (tt == null) {
                    return;
                }
                ZkTreeItem item = (ZkTreeItem)tt;
                ZkMainController.this.myName = item.getName();
                ZkMainController.this.addText(item.getNode());
            }
        });
    }

    public void find() {
        String find = this.find.getText();
        if (find != null && !find.trim().isEmpty()) {
            ZkTreeItem item = (ZkTreeItem)this.treeView.getRoot();
            this.find(item, find);
            this.isSelection = false;
        } else {
            ZkTreeItem item = (ZkTreeItem)this.treeView.getRoot();
            this.recovery(item);
        }
    }

    private void recovery(TreeItem<String> item) {
        ((ZkTreeItem)item).recovery();
        ObservableList zItems = item.getChildren();
        for (TreeItem zItem : zItems) {
            this.recovery((TreeItem<String>)zItem);
        }
    }

    private void find(TreeItem<String> titem, String find) {
        ZkTreeItem item = (ZkTreeItem)titem;
        boolean bl = item.findText(find);
        if (bl && !this.isSelection) {
            MultipleSelectionModel m = this.treeView.getSelectionModel();
            m.select((Object)item);
            this.isSelection = true;
        }
        ObservableList zItems = item.getChildren();
        for (TreeItem zItem : zItems) {
            this.find((TreeItem<String>)zItem, find);
        }
    }

    public void connection() {
        String url = this.zkUrl.getText();
        if (url == null || url.trim().isEmpty()) {
            return;
        }
        String rootPath = this.rootNode.getText();
        if (rootPath == null) {
            this.treeRootNome = PATH;
        } else if ((rootPath = ZkPathUtil.getPath(rootPath, new String[0])).startsWith(PATH)) {
            this.treeRootNome = rootPath;
            rootPath = rootPath.substring(1, rootPath.length());
        } else {
            this.treeRootNome = PATH + rootPath;
        }
        this.client = ZkClientFactory.singleton(url, rootPath);
        ZkMonitoListener monitoListener = ZkMonitoListener.singleton(this.treeView, this.treeRootNome);
        CacheListener cl = new CacheListener(this.log);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 15, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.zkmain = ZkMonito.singleton(this.client, executor, cl, monitoListener);
        Stage stage = (Stage)this.conButt.getScene().getWindow();
        ConnectionTack task = new ConnectionTack(this.client, this.zkmain);
        task.valueProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.conButt.setDisable(true);
                this.closeButt.setDisable(false);
                this.findButt.setDisable(false);
            } else {
                this.closeConnection();
                String t = "\u9519\u8bef";
                String text = "\u94fe\u63a5\u5931\u8d25 : " + url + "\n\u8bf7\u68c0\u67e5IP\u6216\u7aef\u53e3\u662f\u5426\u6b63\u786e!";
                Window.alertError(Alert.AlertType.ERROR, stage, t, text).showAndWait();
                System.out.println("\u94fe\u63a5\u5931\u8d25");
            }
        });
        ProgressFrom progressFrom = new ProgressFrom(task, stage);
        progressFrom.activateProgressBar();
    }

    public void closeConnection() {
        if (this.zkmain != null) {
            ZkMonito.stop();
        }
        if (this.client != null) {
            ZkClientFactory.close();
        }
        this.stoup();
    }

    private void stoup() {
        this.treeView.setRoot(null);
        this.findButt.setDefaultButton(false);
        this.conButt.setDisable(false);
        this.closeButt.setDisable(true);
        this.findButt.setDisable(true);
        this.nodeName.setText(null);
        this.nodeData.setText(null);
        this.log.setText(null);
        this.ctimeText.setText(null);
        this.ctimeText.setTooltip(null);
        this.mtimeText.setText(null);
        this.mtimeText.setTooltip(null);
        this.versionText.setText(null);
        this.cZxidText.setText(null);
        this.mZxidText.setText(null);
        this.dataLengthText.setText(null);
        this.ephemeralOwnerText.setText(null);
        this.numChildrenText.setText(null);
        this.aversionText.setText(null);
        this.pZxidText.setText(null);
        this.cversionText.setText(null);
    }

    private void decode() {
        if (this.myName != null) {
            if (this.urlBox.isSelected()) {
                String text = URLUtil.decode(this.myName);
                if (this.meihua.isSelected()) {
                    String[] ts;
                    this.nodeName.setWrapText(false);
                    StringBuilder sb = new StringBuilder();
                    String[] stringArray = ts = text.split("\\?");
                    int n = ts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] ps;
                        String u = stringArray[n2];
                        String[] stringArray2 = ps = u.split("&");
                        int n3 = ps.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String p = stringArray2[n4];
                            sb.append(p).append("\n");
                            ++n4;
                        }
                        ++n2;
                    }
                    text = sb.toString();
                } else {
                    this.nodeName.setWrapText(true);
                }
                this.nodeName.setText(text);
            } else {
                this.nodeName.setText(this.myName);
            }
        }
    }

    public void urlButto() {
        if (!this.urlBox.isSelected()) {
            this.meihua.setSelected(false);
        }
        this.decode();
    }

    public void meihuaButto() {
        if (this.meihua.isSelected()) {
            this.urlBox.setSelected(true);
        }
        this.decode();
    }

    private void addText(String path) {
        this.decode();
        try {
            CuratorFramework client = ZkClientFactory.singleton();
            if (client == null) {
                return;
            }
            byte[] bs = (byte[])ZkClientFactory.singleton().getData().forPath(path);
            if (bs != null) {
                String text = new String(bs);
                this.nodeData.setText(text);
            } else {
                this.nodeData.setText(null);
            }
            this.setStat(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setStat(String path) throws Exception {
        CuratorFramework client = ZkClientFactory.singleton();
        Stat stat = (Stat)client.checkExists().forPath(path);
        long ctime = stat.getCtime();
        long mtime = stat.getMtime();
        int version = stat.getVersion();
        long cZxid = stat.getCzxid();
        long mZxid = stat.getMzxid();
        int dataLength = stat.getDataLength();
        long ephemeralOwner = stat.getEphemeralOwner();
        int numChildren = stat.getNumChildren();
        int aversion = stat.getAversion();
        long pZxid = stat.getPzxid();
        int cversion = stat.getCversion();
        this.ctimeText.setText(String.valueOf(ctime));
        Tooltip ctimeDate = new Tooltip(SDF.format(new Date(ctime)));
        this.ctimeText.setTooltip(ctimeDate);
        this.mtimeText.setText(String.valueOf(mtime));
        Tooltip mtimeTextDate = new Tooltip(SDF.format(new Date(mtime)));
        this.mtimeText.setTooltip(mtimeTextDate);
        this.versionText.setText(String.valueOf(version));
        this.cZxidText.setText(String.valueOf(cZxid));
        this.mZxidText.setText(String.valueOf(mZxid));
        this.dataLengthText.setText(String.valueOf(dataLength));
        this.ephemeralOwnerText.setText(String.valueOf(ephemeralOwner));
        this.numChildrenText.setText(String.valueOf(numChildren));
        this.aversionText.setText(String.valueOf(aversion));
        this.pZxidText.setText(String.valueOf(pZxid));
        this.cversionText.setText(String.valueOf(cversion));
    }

    private void setTooltip() {
        Tooltip ctime = new Tooltip("\u8282\u70b9\u521b\u5efa\u65f6\u95f4\u6233\n\u5c06\u9f20\u6807\u653e\u5230\u8f93\u5165\u6846\n\u53ef\u4ee5\u770b\u5230\u5177\u4f53\u65f6\u95f4");
        this.ctime.setTooltip(ctime);
        Tooltip mtime = new Tooltip("\u8282\u70b9\u6700\u540e\u4e00\u6b21\u88ab\u4fee\u6539\u7684\u65f6\u95f4\u6233\n\u5c06\u9f20\u6807\u653e\u5230\u8f93\u5165\u6846\n\u53ef\u4ee5\u770b\u5230\u5177\u4f53\u65f6\u95f4");
        this.mtime.setTooltip(mtime);
        Tooltip version = new Tooltip("\u7248\u672c\u53f7");
        this.version.setTooltip(version);
        Tooltip cZxid = new Tooltip("\u8282\u70b9\u88ab\u521b\u5efa\u65f6\u7684\u4e8b\u52a1 ID");
        this.cZxid.setTooltip(cZxid);
        Tooltip mZxid = new Tooltip("\u8282\u70b9\u6700\u540e\u4e00\u6b21\u88ab\u4fee\u6539\u65f6\u7684\u4e8b\u52a1 ID");
        this.mZxid.setTooltip(mZxid);
        Tooltip dataLength = new Tooltip("\u6570\u636e\u957f\u5ea6");
        this.dataLength.setTooltip(dataLength);
        Tooltip ephemeralOwner = new Tooltip("\u5982\u679c\u503c\u4e3a0\u8868\u793a\u6c38\u4e45\u8282\u70b9\n\u5426\u5219\u8868\u793a\u521b\u5efa\u8be5\u4e34\u65f6\u8282\u70b9\u65f6\u7684\n\u4f1a\u8bdd sessionID");
        this.ephemeralOwner.setTooltip(ephemeralOwner);
        Tooltip numChildren = new Tooltip("\u5b50\u8282\u70b9\u6570");
        this.numChildren.setTooltip(numChildren);
        Tooltip aversion = new Tooltip("\u8282\u70b9ACL\u7248\u672c\u53f7");
        this.aversion.setTooltip(aversion);
        Tooltip pZxid = new Tooltip("\u8282\u70b9\u7684\u5b50\u8282\u70b9\u5217\u8868\u6700\u540e\u4e00\u6b21\u88ab\u4fee\u6539\u65f6\u7684\u4e8b\u52a1 ID\n\u53ea\u6709\u5b50\u8282\u70b9\u5217\u8868\u53d8\u66f4\u624d\u4f1a\u66f4\u65b0 pZxid\n\u5b50\u8282\u70b9\u5185\u5bb9\u53d8\u66f4\u4e0d\u4f1a\u66f4\u65b0");
        this.pZxid.setTooltip(pZxid);
        Tooltip cversion = new Tooltip("\u5b50\u8282\u70b9\u7684\u7248\u672c\u53f7");
        this.cversion.setTooltip(cversion);
    }
}

