/*
 * Decompiled with CFR 0.152.
 */
package application.tack;

import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.Background;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class ProgressFrom {
    private Stage dialogStage = new Stage();
    private ProgressIndicator progressIndicator;

    public ProgressFrom(Task<?> task, Stage primaryStage) {
        double x = primaryStage.getX();
        double y = primaryStage.getY();
        double h = primaryStage.getHeight();
        double w = primaryStage.getWidth();
        double x_ = x + w / 2.0 - 50.0;
        double y_ = y + h / 2.0 - 50.0;
        this.dialogStage.setX(x_);
        this.dialogStage.setY(y_);
        this.progressIndicator = new ProgressIndicator();
        this.dialogStage.initOwner((Window)primaryStage);
        this.dialogStage.initStyle(StageStyle.UNDECORATED);
        this.dialogStage.initStyle(StageStyle.TRANSPARENT);
        this.dialogStage.initModality(Modality.APPLICATION_MODAL);
        Label label = new Label("\u6b63\u5728\u94fe\u63a5, \u8bf7\u7a0d\u540e...");
        label.setTextFill((Paint)Color.BLUE);
        this.progressIndicator.setProgress(-1.0);
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        VBox vBox = new VBox();
        vBox.setSpacing(10.0);
        vBox.setBackground(Background.EMPTY);
        vBox.getChildren().addAll((Object[])new Node[]{this.progressIndicator, label});
        Scene scene = new Scene((Parent)vBox);
        scene.setFill(null);
        this.dialogStage.setScene(scene);
        Thread inner = new Thread((Runnable)task);
        inner.start();
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                ProgressFrom.this.dialogStage.close();
            }
        });
    }

    public void activateProgressBar() {
        this.dialogStage.show();
    }

    public Stage getDialogStage() {
        return this.dialogStage;
    }

    public void cancelProgressBar() {
        this.dialogStage.close();
    }
}

