/*
 * Decompiled with CFR 0.152.
 */
package application.window;

import application.ImageUtil;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.image.ImageView;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class Window {
    public static Stage openWindow(String title, Parent root, double width, double height, boolean resizable) {
        Stage window = new Stage();
        window.setTitle(title);
        window.initModality(Modality.APPLICATION_MODAL);
        window.setMinWidth(width);
        window.setMinHeight(height);
        window.getIcons().add((Object)ImageUtil.APP);
        window.setResizable(resizable);
        Scene scene = new Scene(root);
        window.setScene(scene);
        window.showAndWait();
        return window;
    }

    public static Alert alert(Alert.AlertType type, Stage stage, String title, String text, Node node) {
        Alert alert = new Alert(type);
        if (stage != null) {
            double x = stage.getX();
            double y = stage.getY();
            double h = stage.getHeight();
            double w = stage.getWidth();
            Rectangle2D bounds = Screen.getPrimary().getVisualBounds();
            double minX = bounds.getMinX();
            double minY = bounds.getMinY();
            double maxX = bounds.getMaxX();
            double maxY = bounds.getMaxY();
            double x_ = x + w / 2.0 - 180.0;
            double y_ = y + h / 2.0 - 80.0;
            if (minX < x_ && x_ < maxX - 200.0 && minY < y_ && y_ < maxY - 200.0) {
                alert.setX(x_);
                alert.setY(y_);
            }
        }
        alert.setTitle(title);
        alert.setHeaderText(null);
        alert.setContentText(text);
        if (node != null) {
            alert.setGraphic(node);
        }
        return alert;
    }

    public static Alert alertError(Alert.AlertType type, Stage stage, String title, String text) {
        ImageView error = new ImageView();
        error.setImage(ImageUtil.ERROR);
        error.setFitWidth(80.0);
        error.setFitHeight(80.0);
        return Window.alert(type, stage, title, text, (Node)error);
    }
}

