/*
 * Decompiled with CFR 0.152.
 */
package com.rbj.tools.connection;

import com.rbj.tools.connection.MonitoListener;
import com.rbj.tools.util.ZkPathUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;

public class ZkMonito {
    private static final String PATH = "/";
    private Map<String, PathChildrenCache> pathMap = new HashMap<String, PathChildrenCache>();
    private CuratorFramework client = null;
    private ThreadPoolExecutor executor = null;
    private PathChildrenCacheListener listener;
    private MonitoListener monitoListener;
    private ZKPathListener zklistener = new ZKPathListener();
    private static ZkMonito zkMonito = null;

    private ZkMonito(CuratorFramework client, ThreadPoolExecutor executor, PathChildrenCacheListener listener, MonitoListener monitoListener) {
        this.client = client;
        this.listener = listener;
        this.monitoListener = monitoListener;
        this.executor = executor;
    }

    public static ZkMonito singleton(CuratorFramework client, ThreadPoolExecutor executor, PathChildrenCacheListener listener, MonitoListener monitoListener) {
        if (zkMonito == null) {
            zkMonito = new ZkMonito(client, executor, listener, monitoListener);
        }
        return zkMonito;
    }

    public static ZkMonito singleton() {
        return zkMonito;
    }

    public void start() throws Exception {
        this.recursiveMonitor(PATH);
    }

    public static void stop() {
        for (Map.Entry<String, PathChildrenCache> en : ZkMonito.zkMonito.pathMap.entrySet()) {
            en.getValue().clear();
            ZkMonito.zkMonito.monitoListener.removeNodeListener(en.getKey());
        }
        ZkMonito.zkMonito.pathMap.clear();
        ZkMonito.zkMonito.executor.shutdown();
        ZkMonito.zkMonito.monitoListener.clear();
        zkMonito = null;
    }

    private void addMonitor(String nodeName) throws Exception {
        if (this.pathMap.get(nodeName) == null) {
            PathChildrenCache childrenCache = new PathChildrenCache(this.client, nodeName, true, false, (ExecutorService)this.executor);
            childrenCache.getListenable().addListener((Object)this.zklistener, (Executor)this.executor);
            childrenCache.getListenable().addListener((Object)this.listener, (Executor)this.executor);
            childrenCache.start();
            this.pathMap.put(nodeName, childrenCache);
            this.monitoListener.newNodeListener(nodeName);
        }
    }

    private void remove(String path) throws IOException {
        PathChildrenCache cache = this.pathMap.get(path);
        if (cache != null) {
            cache.close();
            this.pathMap.remove(path);
            this.monitoListener.removeNodeListener(path);
        }
    }

    private void recursiveMonitor(String node) throws Exception {
        List list = (List)this.client.getChildren().forPath(node);
        this.addMonitor(node);
        if (list == null) {
            return;
        }
        for (String name : list) {
            String zPath = ZkPathUtil.getPath(node, name);
            this.addMonitor(zPath);
            this.recursiveMonitor(zPath);
        }
    }

    private class ZKPathListener
    implements PathChildrenCacheListener {
        private ZKPathListener() {
        }

        public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
            ChildData node = event.getData();
            String path = node.getPath();
            switch (event.getType()) {
                case CHILD_ADDED: {
                    ZkMonito.this.addMonitor(path);
                    break;
                }
                case CHILD_REMOVED: {
                    ZkMonito.this.remove(path);
                    break;
                }
            }
        }
    }
}

