/*
 * Decompiled with CFR 0.152.
 */
package com.rbj.tools.item;

import application.ImageUtil;
import application.ZkTools;
import application.window.Window;
import com.rbj.tools.connection.ZkClientFactory;
import com.rbj.tools.item.ZkTreeItem;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class ZkTreeCell
extends TreeCell<String> {
    private final ContextMenu addMenu = new ContextMenu();

    public ZkTreeCell() {
        MenuItem addMenuItem = new MenuItem("\u6dfb\u52a0\u8282\u70b9");
        addMenuItem.setOnAction(t -> this.add());
        MenuItem delMenuItem = new MenuItem("\u5220\u9664\u8282\u70b9");
        delMenuItem.setOnAction(t -> this.del());
        this.addMenu.getItems().add((Object)addMenuItem);
        this.addMenu.getItems().add((Object)delMenuItem);
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.setContextMenu(this.addMenu);
            ZkTreeItem zkTree = (ZkTreeItem)this.getTreeItem();
            if (zkTree.getChildren().size() == 0) {
                zkTree.setGraphic(ImageUtil.FILE);
            } else {
                zkTree.setGraphic(ImageUtil.FOLDER);
            }
            Node node = zkTree.getGraphic();
            this.setGraphic(node);
        }
    }

    private void del() {
        TreeItem item = this.getTreeItem();
        final ZkTreeItem zkItem = (ZkTreeItem)item;
        String t = "\u8b66\u544a";
        String text = "   \u5220\u9664\u8282\u70b9\u53ca\u5176\u5b50\u8282\u70b9 !\n\n   \u5220\u9664\u540e\u4e0d\u53ef\u6062\u590d !";
        ImageView working = new ImageView();
        working.setImage(ImageUtil.GJ);
        working.setFitWidth(80.0);
        working.setFitHeight(80.0);
        Alert alert = Window.alert(Alert.AlertType.CONFIRMATION, null, t, text, (Node)working);
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.OK) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        ZkClientFactory.singleton().delete().deletingChildrenIfNeeded().forPath(zkItem.getNode());
                    }
                    catch (Exception e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                String t = "\u9519\u8bef";
                                String text = "\u5220\u9664\u8282\u70b9\u5931\u8d25 !";
                                Window.alertError(Alert.AlertType.ERROR, null, t, text).showAndWait();
                            }
                        });
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    private void add() {
        try {
            VBox root = (VBox)FXMLLoader.load((URL)ZkTools.class.getResource("view/AddZkView.fxml"));
            ZkTreeItem item = (ZkTreeItem)this.getTreeItem();
            Label text = (Label)((HBox)root.getChildren().get(0)).getChildren().get(1);
            text.setText(item.getNode());
            Window.openWindow("  \u6dfb\u52a0\u4e00\u4e2a\u8282\u70b9", (Parent)root, 500.0, 300.0, false);
        }
        catch (IOException e) {
            String t = "\u9519\u8bef";
            String text = "\u65e0\u6cd5\u521b\u5efa\u8282\u70b9";
            Window.alertError(Alert.AlertType.ERROR, null, t, text).showAndWait();
            e.printStackTrace();
        }
    }
}

