/*
 * Decompiled with CFR 0.152.
 */
package com.rbj.tools.item;

import application.ImageUtil;
import com.rbj.tools.util.URLUtil;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;

public class ZkTreeItem
extends TreeItem<String> {
    private String id;
    private String name;
    private String pid;
    private String node;
    private String pnode;
    private HBox root;
    private ImageView ico;
    private HBox tHBox;
    private static final String PATH = "/";

    public ZkTreeItem(String nodePath) {
        super((Object)"");
        this.name = PATH;
        if (!PATH.equals(nodePath)) {
            this.name = nodePath.substring(nodePath.lastIndexOf(PATH) + 1, nodePath.length());
        }
        this.init(nodePath);
    }

    public ZkTreeItem(String nodePath, String name) {
        super((Object)"");
        this.name = name;
        this.init(nodePath);
    }

    private void init(String nodePath) {
        int ps = nodePath.lastIndexOf(PATH);
        String pnode = PATH;
        if (ps > 0) {
            pnode = nodePath.substring(0, nodePath.lastIndexOf(PATH));
        }
        this.node = nodePath;
        this.pnode = pnode;
        this.id = URLUtil.encode(nodePath);
        this.pid = URLUtil.encode(pnode);
        this.root = new HBox();
        this.root.setMinHeight(25.0);
        this.root.setMaxHeight(25.0);
        this.root.setPrefHeight(25.0);
        ObservableList list = this.root.getChildren();
        this.ico = new ImageView();
        this.ico.setFitWidth(25.0);
        this.ico.setFitHeight(25.0);
        list.add(this.ico);
        this.tHBox = new HBox();
        this.tHBox.setPadding(new Insets(1.0, 0.0, 0.0, 2.0));
        list.add(this.tHBox);
        this.setGraphic((Node)this.root);
        this.setGraphic(ImageUtil.FILE);
        this.setText(this.name);
    }

    public void setText(String text) {
        ObservableList list = this.tHBox.getChildren();
        list.clear();
        Label label = this.getLabel(text);
        list.add(label);
    }

    public void recovery() {
        this.setText(this.name);
    }

    public boolean findText(String find) {
        if (!this.getName().contains(find)) {
            this.recovery();
            return false;
        }
        boolean end = this.name.endsWith(find);
        String[] alls = this.name.split(find);
        ObservableList list = this.tHBox.getChildren();
        list.clear();
        int size = alls.length;
        int i = 0;
        while (i < size) {
            list.add(this.getLabel(alls[i]));
            if (i < size - 1) {
                list.add(this.getFindText(find));
            }
            ++i;
        }
        if (end) {
            list.add(this.getFindText(find));
        }
        this.open(this);
        return true;
    }

    private void open(TreeItem<String> item) {
        TreeItem pt = item.getParent();
        if (pt != null) {
            if (!pt.isExpanded()) {
                pt.setExpanded(true);
            }
            this.open((TreeItem<String>)pt);
        }
    }

    private Text getFindText(String text) {
        Text t = new Text(text);
        t.setFill(Paint.valueOf((String)"RED"));
        t.maxHeight(16.0);
        t.minHeight(16.0);
        t.setStrokeType(StrokeType.OUTSIDE);
        t.setStrokeWidth(0.0);
        return t;
    }

    private Label getLabel(String text) {
        Label lable = new Label(text);
        lable.setMinHeight(21.0);
        lable.setMaxHeight(21.0);
        lable.setPrefHeight(21.0);
        return lable;
    }

    public void setGraphic(Image image) {
        this.ico.setImage(image);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPid() {
        return this.pid;
    }

    public String getNode() {
        return this.node;
    }

    public String getPnode() {
        return this.pnode;
    }
}

