/*
 * Decompiled with CFR 0.152.
 */
package com.rbj.tools.listener;

import java.text.SimpleDateFormat;
import java.util.Date;
import javafx.application.Platform;
import javafx.scene.control.TextArea;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;

public class CacheListener
implements PathChildrenCacheListener {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss SSS: ");
    private TextArea log;

    public CacheListener(TextArea log) {
        this.log = log;
    }

    public void childEvent(CuratorFramework arg0, PathChildrenCacheEvent event) throws Exception {
        String msg = null;
        String eName = event.getData().getPath();
        switch (event.getType()) {
            case CHILD_ADDED: {
                msg = "\u6dfb\u52a0\u4e00\u4e2a\u8282\u70b9:" + eName;
                break;
            }
            case CHILD_REMOVED: {
                msg = "\u5220\u9664\u4e00\u4e2a\u8282\u70b9:" + eName;
                break;
            }
            case CHILD_UPDATED: {
                msg = "\u66f4\u65b0\u4e00\u4e2a\u8282\u70b9:" + eName;
                break;
            }
            default: {
                msg = "\u5176\u5b83\u53d8\u5316\u7684\u8282\u70b9:" + eName;
            }
        }
        msg = "\n" + sdf.format(new Date()) + msg;
        this.appendText(msg);
    }

    private void appendText(String msg) {
        if (this.log.getText() == null || this.log.getText().length() < 1024) {
            Platform.runLater(() -> this.log.appendText(msg));
        } else {
            Platform.runLater(() -> this.log.setText(msg));
        }
    }
}

