/*
 * Decompiled with CFR 0.152.
 */
package com.rbj.tools.listener;

import com.rbj.tools.connection.MonitoListener;
import com.rbj.tools.item.ZkTreeItem;
import com.rbj.tools.util.URLUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;

public final class ZkMonitoListener
implements MonitoListener {
    private TreeView<String> treeView;
    private String rootName;
    private final Map<String, ZkTreeItem> VISIBLE = new HashMap<String, ZkTreeItem>();
    private final Map<String, ZkTreeItem> HIDDEN = new HashMap<String, ZkTreeItem>();
    private static ZkMonitoListener listener;

    private ZkMonitoListener(TreeView<String> treeView, String rootName) {
        this.treeView = treeView;
        this.rootName = rootName;
    }

    public static ZkMonitoListener singleton(TreeView<String> treeView, String rootName) {
        if (listener == null) {
            listener = new ZkMonitoListener(treeView, rootName);
        }
        return listener;
    }

    @Override
    public void newNodeListener(String node) {
        if ("/".equals(node)) {
            ZkTreeItem root = new ZkTreeItem(node, this.rootName);
            root.setExpanded(true);
            Platform.runLater(() -> this.treeView.setRoot((TreeItem)root));
            this.setRoot(root);
        } else {
            ZkTreeItem item = new ZkTreeItem(node);
            this.add(item);
        }
    }

    @Override
    public void removeNodeListener(String node) {
        this.remove(node);
    }

    @Override
    public void clear() {
        this.VISIBLE.clear();
        this.HIDDEN.clear();
        listener = null;
    }

    private void setRoot(ZkTreeItem root) {
        this.VISIBLE.put(root.getId(), root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(ZkTreeItem item) {
        if (this.VISIBLE.get(item.getId()) != null) {
            return;
        }
        ZkTreeItem pItem = this.getParent(item);
        if (pItem == null) {
            this.addHidden(item);
        } else {
            Platform.runLater(() -> {
                boolean bl = pItem.getChildren().add((Object)item);
            });
        }
        Set<ZkTreeItem> cItemSet = this.getChildHidden(item);
        Map<String, ZkTreeItem> map = this.HIDDEN;
        synchronized (map) {
            for (ZkTreeItem cItem : cItemSet) {
                Platform.runLater(() -> {
                    boolean bl = item.getChildren().add((Object)cItem);
                });
                this.HIDDEN.remove(cItem.getId());
            }
        }
        this.VISIBLE.put(item.getId(), item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ZkTreeItem item) {
        ZkTreeItem pItem = (ZkTreeItem)item.getParent();
        if (pItem != null) {
            Platform.runLater(() -> {
                boolean bl = pItem.getChildren().remove((Object)item);
            });
        }
        Map<String, ZkTreeItem> map = this.VISIBLE;
        synchronized (map) {
            this.VISIBLE.remove(item.getId());
        }
        map = this.HIDDEN;
        synchronized (map) {
            this.HIDDEN.remove(item.getId());
        }
    }

    private void remove(String node) {
        ZkTreeItem item = this.VISIBLE.get(URLUtil.encode(node));
        if (item != null) {
            this.remove(item);
        }
    }

    private ZkTreeItem getParent(ZkTreeItem item) {
        return this.VISIBLE.get(item.getPid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHidden(ZkTreeItem item) {
        Map<String, ZkTreeItem> map = this.HIDDEN;
        synchronized (map) {
            this.HIDDEN.put(item.getId(), item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ZkTreeItem> getChildHidden(ZkTreeItem item) {
        HashSet<ZkTreeItem> set = new HashSet<ZkTreeItem>();
        Map<String, ZkTreeItem> map = this.HIDDEN;
        synchronized (map) {
            for (ZkTreeItem cItem : this.HIDDEN.values()) {
                if (!item.getId().equals(cItem.getPid())) continue;
                set.add(cItem);
            }
        }
        return set;
    }
}

